<?php
require_once __DIR__.'/../config/database.php';
require_once __DIR__.'/../models/ProgramStudi.php';

$prodiModel = new ProgramStudi($pdo);

// proses form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $aksi = $_POST['aksi'] ?? '';
    if ($aksi === 'tambah') {
        $prodiModel->store([
            'kode_prodi' => $_POST['kode_prodi'],
            'nama_prodi' => $_POST['nama_prodi'],
            'jenjang'    => $_POST['jenjang'],
            'fakultas'   => $_POST['fakultas']
        ]);
    } elseif ($aksi === 'update') {
        $prodiModel->update([
            'kode_prodi' => $_POST['kode_prodi'],
            'nama_prodi' => $_POST['nama_prodi'],
            'jenjang'    => $_POST['jenjang'],
            'fakultas'   => $_POST['fakultas']
        ]);
    }
    header('Location: prodi.php');
    exit;
}

// hapus
if (isset($_GET['hapus'])) {
    $prodiModel->delete($_GET['hapus']);
    header('Location: prodi.php');
    exit;
}

$dataProdi = $prodiModel->all();
$pageTitle = 'Master Program Studi';
include __DIR__.'/../templates/header.php';
?>
<div class="container mt-4">
  <h3>Master Program Studi</h3>

  <div class="card mb-4">
    <div class="card-header">Tambah / Ubah Program Studi</div>
    <div class="card-body">
      <form method="post">
        <div class="row mb-2">
          <div class="col-md-3">
            <label class="form-label">Kode Prodi</label>
            <input type="text" name="kode_prodi" class="form-control" required>
          </div>
          <div class="col-md-5">
            <label class="form-label">Nama Prodi</label>
            <input type="text" name="nama_prodi" class="form-control" required>
          </div>
          <div class="col-md-2">
            <label class="form-label">Jenjang</label>
            <input type="text" name="jenjang" class="form-control" placeholder="S1" required>
          </div>
          <div class="col-md-2">
            <label class="form-label">Fakultas</label>
            <input type="text" name="fakultas" class="form-control">
          </div>
        </div>
        <input type="hidden" name="aksi" value="tambah">
        <button type="submit" class="btn btn-primary btn-sm">Simpan</button>
      </form>
      <small class="text-muted">Untuk edit, hapus dulu baris lalu input ulang (atau bisa dibuat form edit terpisah).</small>
    </div>
  </div>

  <table class="table table-sm table-bordered">
    <thead class="table-light">
      <tr>
        <th>Kode</th>
        <th>Nama Prodi</th>
        <th>Jenjang</th>
        <th>Fakultas</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($dataProdi as $p): ?>
      <tr>
        <td><?= htmlspecialchars($p['kode_prodi']) ?></td>
        <td><?= htmlspecialchars($p['nama_prodi']) ?></td>
        <td><?= htmlspecialchars($p['jenjang']) ?></td>
        <td><?= htmlspecialchars($p['fakultas']) ?></td>
        <td>
          <a href="prodi.php?hapus=<?= urlencode($p['kode_prodi']) ?>" class="btn btn-danger btn-sm"
             onclick="return confirm('Hapus prodi ini?')">Hapus</a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php include __DIR__.'/../templates/footer.php'; ?>
