<?php
require_once __DIR__.'/../config/database.php';
require_once __DIR__.'/../models/KuotaPendaftar.php';

$kuotaModel = new KuotaPendaftar($pdo);

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM kuota_pendaftar WHERE id=?");
$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) {
    die('Data tidak ditemukan');
}

$pageTitle = 'Edit Kuota & Pendaftar';
include __DIR__.'/../templates/header.php';
?>
<div class="container mt-4">
  <h3>Edit Kuota & Pendaftar</h3>

  <form method="post" action="kuota.php">
    <input type="hidden" name="aksi" value="update">
    <input type="hidden" name="id" value="<?= $row['id'] ?>">

    <div class="row mb-3">
      <div class="col-md-3">
        <label class="form-label">Kode Prodi</label>
        <input type="text" class="form-control" value="<?= htmlspecialchars($row['kode_prodi']) ?>" disabled>
      </div>
      <div class="col-md-2">
        <label class="form-label">Tahun</label>
        <input type="number" class="form-control" value="<?= htmlspecialchars($row['tahun']) ?>" disabled>
      </div>
      <div class="col-md-2">
        <label class="form-label">Kuota</label>
        <input type="number" name="kuota" class="form-control" value="<?= htmlspecialchars($row['kuota']) ?>" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Pendaftar</label>
        <input type="number" name="pendaftar" class="form-control" value="<?= htmlspecialchars($row['pendaftar']) ?>" required>
      </div>
    </div>

    <button type="submit" class="btn btn-primary btn-sm">Update</button>
    <a href="kuota.php" class="btn btn-secondary btn-sm">Kembali</a>
  </form>
</div>
<?php include __DIR__.'/../templates/footer.php'; ?>
