<?php
require_once __DIR__.'/../config/database.php';
require_once __DIR__.'/../models/ProgramStudi.php';
require_once __DIR__.'/../models/KuotaPendaftar.php';
require_once __DIR__.'/../models/FiturProdi.php';

$prodiModel  = new ProgramStudi($pdo);
$kuotaModel  = new KuotaPendaftar($pdo);
$fiturModel  = new FiturProdi($pdo);

// proses form input
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $aksi = $_POST['aksi'] ?? '';
    if ($aksi === 'tambah') {
        $kuotaModel->store([
            'kode_prodi' => $_POST['kode_prodi'],
            'tahun'      => $_POST['tahun'],
            'kuota'      => $_POST['kuota'],
            'pendaftar'  => $_POST['pendaftar'],
        ]);
        // hitung ulang fitur prodi ini (realtime)
        $fiturModel->hitungFiturProdi($_POST['kode_prodi']);
    } elseif ($aksi === 'update') {
        $kuotaModel->update([
            'id'        => $_POST['id'],
            'kuota'     => $_POST['kuota'],
            'pendaftar' => $_POST['pendaftar'],
        ]);
        // ambil kode_prodi untuk hitung ulang fitur
        $stmt = $pdo->prepare("SELECT kode_prodi FROM kuota_pendaftar WHERE id=?");
        $stmt->execute([$_POST['id']]);
        if ($kode = $stmt->fetchColumn()) {
            $fiturModel->hitungFiturProdi($kode);
        }
    }
    header('Location: kuota.php');
    exit;
}

// hapus baris
if (isset($_GET['hapus'])) {
    $id = (int)$_GET['hapus'];
    // cari kode_prodi sebelum hapus
    $stmt = $pdo->prepare("SELECT kode_prodi FROM kuota_pendaftar WHERE id=?");
    $stmt->execute([$id]);
    $kode = $stmt->fetchColumn();
    $kuotaModel->delete($id);
    if ($kode) $fiturModel->hitungFiturProdi($kode);
    header('Location: kuota.php');
    exit;
}

$listProdi = $prodiModel->all();
$dataAll   = $kuotaModel->allGrouped();

$pageTitle = 'Data Kuota & Pendaftar';
include __DIR__.'/../templates/header.php';
?>
<div class="container mt-4">
  <h3>Data Kuota & Pendaftar</h3>

  <div class="card mb-3">
    <div class="card-header">Input Kuota & Pendaftar</div>
    <div class="card-body">
      <form method="post" class="row g-2">
        <div class="col-md-3">
          <label class="form-label">Program Studi</label>
          <select name="kode_prodi" class="form-select" required>
            <option value="">--pilih--</option>
            <?php foreach ($listProdi as $p): ?>
            <option value="<?= htmlspecialchars($p['kode_prodi']) ?>">
              <?= htmlspecialchars($p['kode_prodi'].' - '.$p['nama_prodi']) ?>
            </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Tahun</label>
          <input type="number" name="tahun" class="form-control" value="<?= date('Y') ?>" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">Kuota</label>
          <input type="number" name="kuota" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">Pendaftar</label>
          <input type="number" name="pendaftar" class="form-control" required>
        </div>
        <div class="col-md-3 align-self-end">
          <input type="hidden" name="aksi" value="tambah">
          <button type="submit" class="btn btn-primary btn-sm">Simpan</button>
        </div>
      </form>
      <small class="text-muted">Setiap simpan data, fitur dan analisis akan diperbarui saat halaman analisis dibuka.</small>
    </div>
  </div>

  <table class="table table-sm table-bordered">
    <thead class="table-light">
      <tr>
        <th>Prodi</th>
        <th>Tahun</th>
        <th>Kuota</th>
        <th>Pendaftar</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($dataAll as $row): ?>
      <tr>
        <td><?= htmlspecialchars($row['kode_prodi'].' - '.$row['nama_prodi']) ?></td>
        <td><?= htmlspecialchars($row['tahun']) ?></td>
        <td><?= htmlspecialchars($row['kuota']) ?></td>
        <td><?= htmlspecialchars($row['pendaftar']) ?></td>
        <td>
          <a href="kuota_edit.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
          <a href="kuota.php?hapus=<?= $row['id'] ?>" class="btn btn-danger btn-sm"
             onclick="return confirm('Hapus data ini?')">Hapus</a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php include __DIR__.'/../templates/footer.php'; ?>
