<?php
class ProgramStudi {
    private $pdo;
    public function __construct($pdo) { $this->pdo = $pdo; }

    public function all() {
        return $this->pdo->query("SELECT * FROM program_studi ORDER BY kode_prodi")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function find($kode) {
        $stmt = $this->pdo->prepare("SELECT * FROM program_studi WHERE kode_prodi = ?");
        $stmt->execute([$kode]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function store($data) {
        $stmt = $this->pdo->prepare("INSERT INTO program_studi (kode_prodi,nama_prodi,jenjang,fakultas) VALUES (?,?,?,?)");
        return $stmt->execute([$data['kode_prodi'], $data['nama_prodi'], $data['jenjang'], $data['fakultas']]);
    }

    public function update($data) {
        $stmt = $this->pdo->prepare("UPDATE program_studi SET nama_prodi=?, jenjang=?, fakultas=? WHERE kode_prodi=?");
        return $stmt->execute([$data['nama_prodi'], $data['jenjang'], $data['fakultas'], $data['kode_prodi']]);
    }

    public function delete($kode) {
        $stmt = $this->pdo->prepare("DELETE FROM program_studi WHERE kode_prodi=?");
        return $stmt->execute([$kode]);
    }
}
