<?php
class KuotaPendaftar {
    private $pdo;
    public function __construct($pdo) { $this->pdo = $pdo; }

    public function byProdi($kode) {
        $stmt = $this->pdo->prepare("SELECT * FROM kuota_pendaftar WHERE kode_prodi=? ORDER BY tahun");
        $stmt->execute([$kode]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function allGrouped() {
        $sql = "SELECT kp.*, ps.nama_prodi 
                FROM kuota_pendaftar kp 
                JOIN program_studi ps ON kp.kode_prodi = ps.kode_prodi
                ORDER BY kp.kode_prodi, kp.tahun";
        return $this->pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    public function store($data) {
        $stmt = $this->pdo->prepare("INSERT INTO kuota_pendaftar (kode_prodi,tahun,kuota,pendaftar) VALUES (?,?,?,?)");
        return $stmt->execute([$data['kode_prodi'], $data['tahun'], $data['kuota'], $data['pendaftar']]);
    }

    public function update($data) {
        $stmt = $this->pdo->prepare("UPDATE kuota_pendaftar SET kuota=?, pendaftar=? WHERE id=?");
        return $stmt->execute([$data['kuota'], $data['pendaftar'], $data['id']]);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM kuota_pendaftar WHERE id=?");
        return $stmt->execute([$id]);
    }
}
