<?php
class FiturProdi {
    private $pdo;
    public function __construct($pdo) { $this->pdo = $pdo; }

    public function hitungSemuaFitur() {
        // ambil semua kode prodi
        $prodi = $this->pdo->query("SELECT kode_prodi FROM program_studi")->fetchAll(PDO::FETCH_COLUMN);
        foreach ($prodi as $kode) {
            $this->hitungFiturProdi($kode);
        }
    }

    public function hitungFiturProdi($kode_prodi) {
        $stmt = $this->pdo->prepare("SELECT tahun, kuota, pendaftar FROM kuota_pendaftar WHERE kode_prodi=? ORDER BY tahun");
        $stmt->execute([$kode_prodi]);
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (count($rows) == 0) return;

        $totalKuota = 0; $totalPendaftar = 0;
        $tahunAwal = $rows[0]['tahun'];
        $pendAwal  = $rows[0]['pendaftar'];
        $pendAkhir = $rows[count($rows)-1]['pendaftar'];

        foreach ($rows as $r) {
            $totalKuota     += $r['kuota'];
            $totalPendaftar += $r['pendaftar'];
        }
        $nTahun = count($rows);
        $rataPendaftar = $totalPendaftar / $nTahun;
        $rataRasio     = $totalPendaftar / max($totalKuota, 1);

        // tren sederhana: (pendaftar_terakhir - pertama) / jumlah_tahun
        $tren = ($pendAkhir - $pendAwal) / max(($rows[count($rows)-1]['tahun'] - $tahunAwal), 1);

        // kategori_peminatan awal dari rasio (bisa diperbaiki nanti)
        if ($rataRasio >= 2.0)      $kategori = 'Tinggi';
        elseif ($rataRasio >= 1.2)  $kategori = 'Sedang';
        else                         $kategori = 'Rendah';

        // rekomendasi kasar dari rasio & tren (nanti bisa diperbaiki oleh C4.5)
        if ($rataRasio >= 2.0 && $tren > 0)      $rekom = 'Naik';
        elseif ($rataRasio < 1.0 && $tren <= 0)  $rekom = 'Turun';
        else                                      $rekom = 'Tetap';

        $stmt2 = $this->pdo->prepare("
            INSERT INTO fitur_prodi (kode_prodi,rata_pendaftar_5th,rata_rasio_5th,tren_pendaftar,kategori_peminatan,rekomendasi_kuota)
            VALUES (?,?,?,?,?,?)
            ON DUPLICATE KEY UPDATE
              rata_pendaftar_5th = VALUES(rata_pendaftar_5th),
              rata_rasio_5th     = VALUES(rata_rasio_5th),
              tren_pendaftar     = VALUES(tren_pendaftar),
              kategori_peminatan = VALUES(kategori_peminatan),
              rekomendasi_kuota  = VALUES(rekomendasi_kuota)
        ");
        $stmt2->execute([$kode_prodi, $rataPendaftar, $rataRasio, $tren, $kategori, $rekom]);
    }

    public function allWithProdi() {
        $sql = "SELECT fp.*, ps.nama_prodi
                FROM fitur_prodi fp
                JOIN program_studi ps ON fp.kode_prodi = ps.kode_prodi
                ORDER BY fp.rata_pendaftar_5th DESC";
        return $this->pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }
}
