<?php
class KMeans {
    public static function cluster($data, $k = 3, $maxIter = 100) {
        // $data: array of [kode_prodi, x1, x2, x3]
        if (count($data) < $k) return [];

        // inisialisasi centroid awal: ambil k data pertama
        $centroids = [];
        for ($i=0; $i<$k; $i++) {
            $centroids[$i] = [$data[$i][1], $data[$i][2], $data[$i][3]];
        }

        $assignments = array_fill(0, count($data), 0);

        for ($iter=0; $iter<$maxIter; $iter++) {
            $changed = false;

            // assignment
            for ($i=0; $i<count($data); $i++) {
                $x = [$data[$i][1], $data[$i][2], $data[$i][3]];
                $bestCluster = 0;
                $bestDist = PHP_INT_MAX;
                for ($c=0; $c<$k; $c++) {
                    $d = self::distance($x, $centroids[$c]);
                    if ($d < $bestDist) {
                        $bestDist = $d;
                        $bestCluster = $c;
                    }
                }
                if ($assignments[$i] != $bestCluster) {
                    $assignments[$i] = $bestCluster;
                    $changed = true;
                }
            }

            // update centroid
            $sums = [];
            $counts = [];
            for ($c=0; $c<$k; $c++) {
                $sums[$c]   = [0,0,0];
                $counts[$c] = 0;
            }
            for ($i=0; $i<count($data); $i++) {
                $c = $assignments[$i];
                $sums[$c][0] += $data[$i][1];
                $sums[$c][1] += $data[$i][2];
                $sums[$c][2] += $data[$i][3];
                $counts[$c]  += 1;
            }
            for ($c=0; $c<$k; $c++) {
                if ($counts[$c] > 0) {
                    $centroids[$c][0] = $sums[$c][0] / $counts[$c];
                    $centroids[$c][1] = $sums[$c][1] / $counts[$c];
                    $centroids[$c][2] = $sums[$c][2] / $counts[$c];
                }
            }

            if (!$changed) break;
        }

        // hasil: [kode_prodi => cluster_index]
        $result = [];
        for ($i=0; $i<count($data); $i++) {
            $result[$data[$i][0]] = $assignments[$i] + 1; // cluster mulai 1
        }
        return $result;
    }

    private static function distance($a, $b) {
        return sqrt(
            pow($a[0]-$b[0], 2) +
            pow($a[1]-$b[1], 2) +
            pow($a[2]-$b[2], 2)
        );
    }
}
